param(
    [Parameter(Mandatory = $false)]
    [string]$outputFilePath = "C:\AOFG\system_report.json"
)

Set-Location $PSScriptRoot
.("..\AOFLibrary\AOFLibrary.ps1")

$gpus = Get-GPUs

function Get-AvailableRAM()
{
    return (Get-CIMInstance Win32_OperatingSystem | Select-Object FreePhysicalMemory).FreePhysicalMemory / 1MB # result is in GB
}

function Get-TotalSystemRAM()
{
    return (Get-CimInstance Win32_PhysicalMemory | Measure-Object -Property capacity -Sum).sum / 1GB
}

function Is-HypervEnabled()
{
    return (Get-ComputerInfo -property "HyperV*").HyperVisorPresent
}

function Get-WindowsInfo()
{
    $windows = Get-CIMInstance Win32_OperatingSystem
    return @{
        "Name" = (Get-WmiObject -class Win32_OperatingSystem).Caption
        "Architecture" = $windows.OSArchitecture
        "Version" = $windows.Version
    }
}

function Get-StorageInfo()
{
    return ( Get-Partition | ForEach-Object {
        if ($_.Size -gt 1GB -and $_.DriveLetter) {
            return (Get-Volume -DriveLetter $_.DriveLetter) | Select-Object -Property "DriveLetter", "Size", "SizeRemaining"
        }
    })
}

function Get-ProcessorInfo()
{
    return ((Get-ComputerInfo -Property CsProcessors).CsProcessors)
}

$ram = @{
    "TotalGB" = Get-TotalSystemRAM
    "AvailableGB" = Get-AvailableRAM
}

$hyperv = @{
    "Enabled" = Is-HypervEnabled
}

$windows = Get-WindowsInfo

$storage = Get-StorageInfo

$cpu = Get-ProcessorInfo

$json = @{
    "Gpus" = @($gpus)
    "Cpu" = @($cpu)
    "Ram" = $ram
    "Hyperv" = $hyperv
    "Windows" = $windows
    "Storage" = @($storage)
} | ConvertTo-Json -Depth 4

Write-Output $json
$json | Out-File -FilePath $outputFilePath
